#version 330
#extension GL_EXT_gpu_shader4 : enable
// shadetober #30_catchMod01.fsh by percentcer

//https://www.shadertoy.com/view/wscSWf
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define MAXD 30.
#define PI 3.141
#define TAU 6.283

#define REPETITION_PERIOD 4.
#define HALF_PERIOD REPETITION_PERIOD * .5

#define DEBUG_LIGHT_SOURCE 0

mat3 roty(float a)
{
    return mat3(cos(a), 0., sin(a), 0., 1., 0., -sin(a), 0., cos(a));
}
mat3 rotx(float a)
{
    return mat3(1., 0., 0., 0., cos(a), sin(a), 0., -sin(a), cos(a));
}

vec3 spherical(vec3 cart)
{
    float rho = length(cart);
    float theta = atan(cart.y, cart.x); // [-pi, pi]
    float phi = acos(cart.z / rho);     // [0, pi]
    return vec3(rho, theta, phi);
}

float expStep(float x, float k, float n) { return exp(-k * pow(x, n)); }

float sphere(vec3 p, float rad) { return length(p) - rad; }


float shape(vec3 p)
{
#if 1
    // da experiment zone
    //p = p.zxy;
    mat3 rot = roty((iMouse.x / iResolution.x - .5) * 10.);
    // mat3 rot = roty(iTime);
    p *= rot;
#endif
#if 1
    vec3 sp = spherical(p);

    const float latPeaks = 5.;
    const float latMin = .7;
    float lateralRadius = mix(latMin, 1.0, cos(sp.y * latPeaks) * .5 + .5);

    const float longPeaks = 6.;
    const float longSpeed = 8.;
    const float longDamp = 0.1;
    float longitudinalWiggle = cos((sp.z * 2.) * longPeaks + iTime * longSpeed) * longDamp;

    return length(p) - (lateralRadius + longitudinalWiggle);
#else
    return sphere(p, 1.);
#endif
}

vec2 map(vec3 p)
{
    // return a distance and a material id
    vec2 cur = vec2(MAXD, 0.);

    vec2 shp = vec2(shape(p), 1.);
    if (shp.x < cur.x)
    {
        cur = shp;
    }

#if DEBUG_LIGHT_SOURCE
    vec2 dbg = vec2(sphere(p - vec3(0., 1., 3.) * roty(iTime), .01), 2.);
    if (dbg.x < cur.x)
    {
        cur = dbg;
    }
#endif

    return cur;
}

vec3 norm(vec3 p)
{
    vec2 ep = vec2(0.001, 0.0);
    return normalize(
        map(p).r - vec3(map(p - ep.xyy).r, map(p - ep.yxy).r, map(p - ep.yyx).r));
}

vec3 cell(vec3 p) { return floor((p + vec3(HALF_PERIOD)) / REPETITION_PERIOD); }

// https://iquilezles.org/articles/distfunctions
vec3 opRep(in vec3 p, in vec3 c)
{
    vec3 localpos = mod(p + c / 2., c) - c / 2.;
    vec3 cell = cell(p);
    vec3 noise = texture2D(iChannel0, vec2(cell.x, cell.y * cell.z) * .1).rgb;
    vec3 offs = noise - .5;
    
    return localpos*rotx(sin(iTime*noise.x)*noise.y) + offs*2.;
}

vec4 march(vec3 ro, vec3 rd, int invert)
{
    float t = 0.;
    vec4 ret;

    for (int i = 0; i < 100; i++)
    {
        ret.xyz = ro + rd * t;
        vec2 d = map(opRep(ret.xyz, vec3(REPETITION_PERIOD))) * vec2(invert, 1);

        if (d.x < .1)
        {
            ret.w = d.y;
            break;
        }

        // only using a portion of the sphere step
        // because I was getting a lot of errors from the
        // shape distortion with the full step
        t += d.x * .2f;

        if (t > MAXD)
        {
            break;
        }
    }
    return ret;
}

vec3 sss(vec3 p, vec3 rd, vec3 lp, vec3 lc)
{
    vec3 origP = p;
    p = opRep(p, vec3(REPETITION_PERIOD));
    // from https://www.alanzucconi.com/2017/08/30/fast-subsurface-scattering-1/
    vec3 L = normalize(lp - p);
    const float subsurfaceDistortion = .5;

    // figure out if our point is the light's entry or exit
    float inShadow = -sign(dot(norm(p), L));
    vec3 lightEgress = march(p + (inShadow * L * .05), inShadow * L, -1).xyz;
    vec3 lightIngress = p;
    if (inShadow > 0.)
    {
        lightIngress = lightEgress;
        lightEgress = p.xyz;
    }

    // fudging a bit but a length of 2 is about the max width of this shape
    // todo currently unused
    // float thickness = length(lightEgress - lightIngress) / 2.;
    vec3 N = norm(lightEgress);

    vec3 cell = cell(origP);
    vec3 noiseOffset =
        texture(iChannel0, vec2(cell.x, cell.y + cell.z) * .1).rgb-.5;
    vec3 basecolor = vec3(.6, 1., .2) + noiseOffset;

    float lightAlign = max(0., dot(norm(p.xyz), L));

    vec3 I_sss =
        max(0., dot(rd, normalize(L + N * subsurfaceDistortion))) * basecolor;
    vec3 I_diff = lightAlign * basecolor;

    vec3 refl = reflect(L, norm(p.xyz));
    float specAlign = abs(dot(rd, refl)); // abs so we get shinies on both sides
    float I_spec = pow(specAlign, 50.);

    return I_sss + I_diff + I_spec;
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    vec2 uv = (gl_FragCoord.xy * 2. - iResolution.xy) / iResolution.y;
	vec3 bgcol = vec3(.4,.6, 0.);
    vec3 col = bgcol;

    vec3 ro = vec3(0., 0., -1.);
    vec3 rd = normalize(vec3(uv.xy, -2.));

    // start the march a little ahead of the
    // actual ro to enforce a near plane
    vec4 p = march(ro + rd * 2., rd, 1);

    vec3 lp = vec3(0., 0., -3.);
    vec3 lc = vec3(1., 1., .878);
    lp *= roty(iTime);

    if (p.w == 1.)
    {
        col = sss(p.xyz, rd, lp, lc);
    }
#if DEBUG_LIGHT_SOURCE
    if (p.w == 2.)
    {
        col = lc;
    }
#endif
    
    col = mix(col, bgcol, length(p.xyz)/MAXD);
    col *= 1.-length((uv+vec2(sin(iTime),0.))*.25);

    gl_FragColor = vec4(col, 1.0);
}